<?php

namespace App\Http\Controllers\TherapistCommunitys;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Broadcast;
use App\Http\Requests\TherapistCommunitys\TherapistCommunityBroadcasts\CreateRequest;
use App\Http\Resources\Web\BroadcastsResource;
use Excel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TherapistCommunityBroadcastsController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('therapist_community');
        // $this->middleware('permission:therapist_community_broadcasts.index');
        // $this->middleware('permission:therapist_community_broadcasts.create',['only' => ['store']]);
        // $this->middleware('permission:therapist_community_broadcasts.update',['only' => ['update']]);
        // $this->middleware('permission:therapist_community_broadcasts.delete',['only' => ['destroy']]);
        // $this->middleware('permission:therapist_community_broadcasts.export',['only' => ['export']]);
        // $this->middleware('permission:therapist_community_broadcasts.import',['only' => ['import']])
        // $this->middleware('permission:therapist_community_broadcasts.update|therapist_community_broadcasts.is_active',['only' => ['updateStatus']]);
    }

    /********* Getter For Pagination, Searching And Sorting  ***********/
    public function getter($req = null, $export = null)
    {
        $therapist_community = auth()->user()->therapist_community;
        if ($req != null) {
            $therapist_community_broadcasts =  $therapist_community->therapist_community_broadcasts()->withAll();
            if ($req->trash && $req->trash == 'with') {
                $therapist_community_broadcasts =  $therapist_community_broadcasts->withTrashed();
            }
            if ($req->trash && $req->trash == 'only') {
                $therapist_community_broadcasts =  $therapist_community_broadcasts->onlyTrashed();
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $therapist_community_broadcasts = $therapist_community_broadcasts->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {

                $therapist_community_broadcasts = $therapist_community_broadcasts->whereLike(['name', 'description'], $req->search);
            }
            if ($req->sort && $req->sort['field'] != null && $req->sort['type'] != null) {
                $therapist_community_broadcasts = $therapist_community_broadcasts->OrderBy($req->sort['field'], $req->sort['type']);
            } else {
                $therapist_community_broadcasts = $therapist_community_broadcasts->OrderBy('id', 'desc');
            }
            if ($export != null) { // for export do not paginate
                $therapist_community_broadcasts = $therapist_community_broadcasts->get();
                return $therapist_community_broadcasts;
            }
            $totalTherapistCommunityBroadcasts = $therapist_community_broadcasts->count();
            $therapist_community_broadcasts = $therapist_community_broadcasts->paginate($req->perPage);
            $therapist_community_broadcasts = BroadcastsResource::collection($therapist_community_broadcasts)->response()->getData(true);

            return $therapist_community_broadcasts;
        }
        $therapist_community_broadcasts = BroadcastsResource::collection($therapist_community->therapist_community_broadcasts()->withAll()->orderBy('id', 'desc')->paginate(10))->response()->getData(true);
        return $therapist_community_broadcasts;
    }

    /********* FETCH ALL TherapistCommunityBroadcasts ***********/
    public function index()
    {
        $therapist_community_broadcasts =  $this->getter();
        $response = generateResponse($therapist_community_broadcasts, count($therapist_community_broadcasts['data']) > 0 ? true : false, 'TherapistCommunityBroadcasts Fetched Successfully', null, 'collection');
        return response()->json($response, 200);
    }

    /********* FILTER TherapistCommunityBroadcasts FOR Search ***********/
    public function filter(Request $request)
    {
        $therapist_community_broadcasts = $this->getter($request);
        $response = generateResponse($therapist_community_broadcasts, count($therapist_community_broadcasts['data']) > 0 ? true : false, 'Filter TherapistCommunityBroadcasts Successfully', null, 'collection');
        return response()->json($response, 200);
    }

    /********* ADD NEW TherapistCommunityBroadcast ***********/
    public function store(CreateRequest $request)
    {
        $therapist_community = auth()->user()->therapist_community;
        try {
            DB::beginTransaction();
            $request->merge(['created_by_user_id' => auth()->user()->id]);
            $data = $request->all();
            $data['image'] = uploadCroppedFile($request, 'image', 'therapist_community_broadcasts');
            $data['audio'] = uploadFile($request, 'audio', 'therapist_community_broadcasts');
            $data['video'] = uploadFile($request, 'video', 'therapist_community_broadcasts');
            $therapist_community_broadcast = $therapist_community->therapist_community_broadcasts()->create($data);
            $therapist_community_broadcast->slug = Str::slug($therapist_community_broadcast->name . ' ' . $therapist_community_broadcast->id, '-');
            $therapist_community_broadcast->save();
            $therapist_community_broadcast->tags()->sync($request->tag_ids);
            $therapist_community_broadcast = $therapist_community->therapist_community_broadcasts()->withAll()->find($therapist_community_broadcast->id);
            $therapist_community_broadcast = new BroadcastsResource($therapist_community_broadcast);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            request()->session()->flash('alert', ['message' => 'Invalid Request', 'type' => 'error']);
        }
        return redirect()->back();
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show($therapist_community_broadcast)
    {
        $therapist_community = auth()->user()->therapist_community;
        if ($therapist_community_broadcast->therapist_community_id != $therapist_community->id) {
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_community_broadcast = $therapist_community->therapist_community_broadcasts()->withAll()->find($therapist_community_broadcast);
        if ($therapist_community_broadcast) {
            $therapist_community_broadcast = new BroadcastsResource($therapist_community_broadcast);
            $response = generateResponse($therapist_community_broadcast, true, 'TherapistCommunityBroadcast Fetched Successfully', null, 'object');
        } else {
            $response = generateResponse(null, false, 'TherapistCommunityBroadcast Not FOund', null, 'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistCommunityBroadcast ***********/
    public function update(CreateRequest $request, Broadcast $therapist_community_broadcast)
    {
        // dd($request->all());
        $therapist_community = auth()->user()->therapist_community;
        if ($therapist_community_broadcast->therapist_community_id != $therapist_community->id) {
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        try {
            DB::beginTransaction();
            $request->merge(['last_updated_by_user_id' => auth()->user()->id]);
            $data = $request->all();
            if ($request->image) {
                $data['image'] = uploadCroppedFile($request, 'image', 'therapist_community_broadcasts', $therapist_community_broadcast->image);
            } else {
                $data['image'] = $therapist_community_broadcast->image;
            }

            if ($request->audio) {
                $data['audio'] = uploadFile($request, 'audio', 'therapist_community_broadcasts');
            } else {
                $data['audio'] = $therapist_community_broadcast->audio;
            }

            if ($request->video) {
                $data['video'] = uploadFile($request, 'video', 'therapist_community_broadcasts');
            } else {
                $data['video'] = $therapist_community_broadcast->video;
            }
            $therapist_community_broadcast->update($data);
            $therapist_community_broadcast = $therapist_community_broadcast->find($therapist_community_broadcast->id);
            $slug = Str::slug($therapist_community_broadcast['name'] . ' ' . $therapist_community_broadcast->id, '-');
            $therapist_community_broadcast->update(
                [
                    'slug' => $slug
                ]
            );
            $therapist_community_broadcast->tags()->sync($request->tag_ids);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            request()->session()->flash('alert', ['message' => 'Invalid Request', 'type' => 'error']);
        }
        return redirect()->back();
    }

    /********* UPDATE TherapistCommunityBroadcast Status***********/
    public function updateStatus(Request $request, Broadcast $therapist_community_broadcast)
    {
        $therapist_community = auth()->user()->therapist_community;
        if ($therapist_community_broadcast->therapist_community_id != $therapist_community->id) {
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_community_broadcast->update([
            'is_active' => $therapist_community_broadcast->is_active == 1 ? 0 : 1
        ]);
        $response = generateResponse(null, true, 'TherapistCommunityBroadcast Status Updated Successfully', null, 'object');
        return response()->json($response, 200);
    }


    /********* DELETE TherapistCommunityBroadcast ***********/
    public function destroy(Request $request, Broadcast $therapist_community_broadcast)
    {
        $therapist_community = auth()->user()->therapist_community;
        if ($therapist_community_broadcast->therapist_community_id != $therapist_community->id) {
            request()->session()->flash('alert', ['message' => 'Invalid Request', 'type' => 'error']);
            return redirect()->back();
        }
        if ($therapist_community_broadcast->trashed()) {
            request()->session()->flash('alert', ['message' => 'Already in Trash', 'type' => 'error']);
        } else {
            $therapist_community_broadcast->delete();
        }
        return redirect()->back();
    }
    /*********Permanently DELETE TherapistCommunityBroadcast ***********/
    public function destroyPermanently(Request $request, $therapist_community_broadcast)
    {
        $therapist_community = auth()->user()->therapist_community;
        $therapist_community_broadcast = $therapist_community->therapist_community_broadcasts()->withTrashed()->find($therapist_community_broadcast);
        if ($therapist_community_broadcast) {
            if ($therapist_community_broadcast->therapist_community_id != $therapist_community->id) {
                return redirect()->back()->withErrors([
                    'message' => 'Invalid Request',
                    'type' => 'error'
                ]);
            }
            if ($therapist_community_broadcast->trashed()) {
                $therapist_community_broadcast->forceDelete();
                $response = generateResponse(null, true, 'TherapistCommunityBroadcast Deleted Successfully', null, 'object');
            } else {
                $response = generateResponse(null, false, 'TherapistCommunityBroadcast is not in trash to delete permanently', null, 'object');
            }
        } else {
            $response = generateResponse(null, false, 'TherapistCommunityBroadcast not found', null, 'object');
        }
        return response()->json($response, 200);
    }
    /********* Restore TherapistCommunityBroadcast ***********/
    public function restore(Request $request, $therapist_community_broadcast)
    {
        $therapist_community = auth()->user()->therapist_community;
        $therapist_community_broadcast = $therapist_community->therapist_community_broadcasts()->withTrashed()->find($therapist_community_broadcast);
        if ($therapist_community_broadcast->trashed()) {
            $therapist_community_broadcast->restore();
            $response = generateResponse(null, true, 'TherapistCommunityBroadcast Restored Successfully', null, 'object');
        } else {
            $response = generateResponse(null, false, 'TherapistCommunityBroadcast is not trashed', null, 'object');
        }
        return response()->json($response, 200);
    }
}
